/**************************************************************
 * Simple Graph with the Arduino over Serial
 *
 * Jun2016, dernulleffekt.de
 * 
 */

import processing.serial.*;

Serial myPort;        // The serial port
int xPos = 1;         // horizontal position of the graph

float fValue;
boolean newVal = false;

void setup () {
  size(400, 300);
  // Prints out the available serial ports.
  println(Serial.list());
  // Modify this line, by changing the "0" to the index of the serial
  // port corresponding to your Arduino board (as it appears in the list
  // printed by the line above).
  myPort = new Serial(this, Serial.list()[4], 9600);
  myPort.bufferUntil('\n');
  background(0);
  stroke(127, 34, 255);
}

 //draws the graph depending on the data from the serialEvent
void draw () {
  if (newVal) {
    line(xPos, height, xPos, height - fValue);
    if (++xPos >= width) {
      xPos = 0;
      background(0);
    }
    newVal = false;
  }
}

 //reads the data from the Arduino
void serialEvent (Serial myPort) {
  String inString = myPort.readStringUntil('\n');
  if (inString != null) {
    inString = trim(inString);
    fValue = float(inString);
    fValue = map(fValue, 0, 1023, 0, height);
    newVal = true;
  }
}