/**
 * Pause, Play and Change Video Speed with the Arduino (Firmata)
 *
 * Jun2016, dernulleffekt.de
 * 
 */

import processing.video.*;
import processing.serial.*;
import cc.arduino.*;

Arduino arduino;

Movie myMovie;

void setup() {
  size(640, 360);
  // Prints out the available serial ports.
  println(Arduino.list());
  // Modify this line, by changing the "0" to the index of the serial
  // port corresponding to your Arduino board (as it appears in the list
  // printed by the line above).
  arduino = new Arduino(this, Arduino.list()[4], 57600);
  
  for (int i = 0; i <= 13; i++)
    arduino.pinMode(i, Arduino.INPUT);
  
  background(0);
  myMovie = new Movie(this, "transit.mkv");
  myMovie.loop();
}

// Called every time a new frame is available to read
void movieEvent(Movie movie) {
  myMovie.read();  
}

void draw() {  
  image(myMovie, 0, 0);
  // read the Arduino Analog Input and control the speed of the video
  float newSpeed = arduino.analogRead(0);
  newSpeed = map(newSpeed,0,1023,0,2);
  myMovie.speed(newSpeed);
  // pause the video if an button on pin 2 is pressed
  if (arduino.digitalRead(2) == Arduino.HIGH){
    myMovie.pause();
  }
  else{
    myMovie.play();
  }
  // shows the speed in the left corner
  fill(255);
  text(nfc(newSpeed, 2) + "X", 10, 30); 
}  