/*=============================================
 *Motor Control Board mit L298N H-Bridge
 *2 Analoge Ausgaenge und 2 Potis
 *4 Taster und 4 Umschalter für die H-Bridge
 *=============================================
 * 17.Feb.2013
 *
 * http://dernulleffekt.de
*/



//Definition der Variablen
int gAusgang1 = 9;              // Auswahl des Pins fuer den Analogausgang
int gAusgang2 = 10;              // ...
int gIN1 = 6;
int gIN2 = 7;
int gIN3 = 11;
int gIN4 = 12;
int gTaster1 = 2;
int gTaster2 = 3;
int gTaster3 = 4;
int gTaster4 = 5;
int gKontrollLed = 13;          // Auswahl des Pins fuer die Kontroll LED
int gPotiPin1 = 0;    // Auswahl des Pins fuer dem 1 Poti
int gPotiPin2 = 1;    // Auswahl des Pins fuer dem 2 Poti
int gWert1 = 0;       // Variable um die Messergebnisse zu speichern
int gWert2 = 0;       // Variable um die Messergebnisse zu speichern


void setup() {
  pinMode(gAusgang1, OUTPUT);
  pinMode(gAusgang2, OUTPUT);
  pinMode(gIN1, OUTPUT);
  pinMode(gIN2, OUTPUT);
  pinMode(gIN3, OUTPUT);
  pinMode(gIN4,OUTPUT);
  digitalWrite(gIN1, LOW);
  digitalWrite(gIN2, LOW);
  digitalWrite(gIN3, LOW);
  digitalWrite(gIN4, LOW);
  pinMode(gTaster1, INPUT);
  pinMode(gTaster2, INPUT);
  pinMode(gTaster3, INPUT);
  pinMode(gTaster4, INPUT);
  digitalWrite(gKontrollLed, HIGH);   // Kontroll LED An
  Serial.begin(9600);       // Serielle Verbindung konfigurieren
}

void loop() {
  Speed();
  Direction();
  Print();
}
  
 void Speed() {
  gWert1 = analogRead(gPotiPin1);    // auslesen des Wertes des ersten Potis
  gWert1 = map(gWert1,0,1023,0,255);
  
  gWert2 = analogRead(gPotiPin2);    // auslesen des Wertes des ersten Potis
  gWert2 = map(gWert2, 0,1023,0,255);
  
  // die Werte an den analogen Ausgaengen muessen zwischen 0 und 255 liegen
  analogWrite(gAusgang1, gWert1);   // einstellen des analogen Ausganges
  analogWrite(gAusgang2, gWert2);   // einstellen des analogen Ausganges
 }
 
 void Direction(){
  if (digitalRead(gTaster3) == HIGH){
  digitalWrite(gIN1, LOW);
  digitalWrite(gIN2, LOW);
  }
  else{
    if (digitalRead(gTaster1) == HIGH){
    digitalWrite(gIN2, LOW);
    digitalWrite(gIN1, HIGH);
    }
    else{
    digitalWrite(gIN1, LOW);
    digitalWrite(gIN2, HIGH);
    }
  }
  if (digitalRead(gTaster4) == HIGH){
  digitalWrite(gIN3, LOW);
  digitalWrite(gIN4, LOW);
  }
  else{
    if (digitalRead(gTaster2) == HIGH){
    digitalWrite(gIN4, LOW);
    digitalWrite(gIN3, HIGH);
    }
    else{
    digitalWrite(gIN3, LOW);
    digitalWrite(gIN4, HIGH);
   }
  }
}

void Print(){
  Serial.print(gWert1);
  Serial.print("--");
  Serial.println(gWert2);           // Daten Senden
}



