/*==========================================
 *Einfachtes stereo "Theremin"
 *==========================================
 *
 *  PWM9-----------Sound links
 *  PWM10----------Sound rechts
 *  
 *  A0-------------Draht
 *  
 *==========================================
 *http://dernulleffekt.de
 */

int Sound1 = 9;            // Pin fu:r den Sound links
int Sound2 = 10;           // Pin fu:r den Sound rechts
int Draht = A0;            // Pin fu:r den Draht
long TonHoehe = 100;       // Variable zum Speichern des ausgelesenen Wertes
long SinusTon = 100;       // Variable zum Speichern des sinus Wertes
long Winkel = 1;

void setup(){
  pinMode(Sound1,OUTPUT);  // Festlegen des Sound-Pins links als Ausgang
  pinMode(Sound2,OUTPUT);  // Festlegen des Sound-Pins rechts als Ausgang
}

void loop(){
  TonHoehe = 5 * (analogRead(Draht)+ 10);  // Auslesen des Analogen Einganges (0 bis 1023) und der Variablen zuweisen, ....
                                           // ... umrechnen in Werte zwischen 100 und 3099
  SinusKurve();                            // Funktion zur Berechnung einer Sinuskurve
                                         
  digitalWrite(Sound1,HIGH);               // Sound 1 anschalten
  digitalWrite(Sound2,LOW);                // Sound 2 ausschalten
  delayMicroseconds(TonHoehe);             // Pause zwischen 100 und 3099

  digitalWrite(Sound1, LOW);               // Sound 1 ausschalten
  digitalWrite(Sound2,HIGH);               // Sound 2 anschalten
  delayMicroseconds(SinusTon);             // Pause zwischen 0 und 100
}

// Funktion um eine Sinuskurve zu Berechnen
void SinusKurve(){
  Winkel++;                // Erhoehen des Winkels um 1
  if (Winkel > 179){       // nach einer halben "Umdrehung" ...
    Winkel = 1;            // ...  den Winkel wieder zuru:cksetzen (Winkel von 1 bis 180 Grad)
  }
  SinusTon = 100 * sin(Winkel*PI/180); // Sinuswert des Winkel (im Bogenmass) mit 100 multiplizieren
}
