/*=================================================
 *LED mit einem "Motor-Sensor" An- und Aus-Schalten
 *=================================================
 *
 * +5V------15k--+--15k---------GND 
 *               |
 *              Motor
 *               |
 * A0------------+
 *
 *=================================================
 * http://dernulleffekt.de
 */


int Wert = 0;          // Variable zum Speichern des ausgelesenen Wertes
int Led = 13;          // Pin fu:r die Led
int Motor = A0;        // Pin fu:r den Motor-Sensor

void setup(){
  pinMode(Led,OUTPUT);    // Festlegen des Led-Pins als Ausgang
  digitalWrite(Led,HIGH); // Led anschalten
  Serial.begin(9600);     // Initialisieren des Seriellen Ausganges mit 9600 Baud
}


void loop(){
  Wert = analogRead(Motor);  // Auslesen des Analogen Einganges und Speichern
  if (Wert > 600){           // Wenn der Wert gro:sser als 600 ist, dann ...
    digitalWrite(Led,HIGH);  // ... Led anschalten
  }
  if (Wert < 400){           // Wenn der Wert kleiner als 400 ist, dann ....
    digitalWrite(Led,LOW);   // ... Led ausschalten
  }
  Serial.println(Wert);      // Den Wert an den Terminal schicken

}

