/*******************************************************************
 * Ein Programm um
 * 2 analoge Eingaenge und 4 digitale Eingaenge auszulesen
 * und das Ergebniss zu drucken.
 * 16_Apr_2015
 * Wolfgang Spahn
 *
 * www.dernulleffekt.de
 *******************************************************************
 */


int PotiPin1 = 0;  // Auswahl des Pins fu:r dem 1 Poti
int PotiPin2 = 1;  // Auswahl des Pins fu:r dem 2 Poti
int TastPin1 = 2;  // Auswahl des Pins fu:r den Taster 1
int TastPin2 = 7;  // Auswahl des Pins fu:r den Taster 2
int TastPin3 = 8;  // Auswahl des Pins fu:r den Taster 3
int TastPin4 = 12; // Auswahl des Pins fu:r den Taster 4
int ledPin = 13;   // Pin fu:r die LED

int wert1 = 0;     // Variable um das Messergebniss des analogen Einganges zu speichern
int wert2 = 0;
int Taster1 = 0;   // Variable um das Messergebniss des digitalen Einganges zu speichern
int Taster2 = 0;
int Taster3 = 0;
int Taster4 = 0;

void setup() {
  pinMode(ledPin, OUTPUT);  // LED-Pin als Ausgang setzen
  pinMode(TastPin1, INPUT_PULLUP); // Taster-Pin als Input setzen, mit Pullupwiderstand
  pinMode(TastPin2, INPUT_PULLUP);
  pinMode(TastPin3, INPUT_PULLUP);
  pinMode(TastPin4, INPUT_PULLUP);
  Serial.begin(9600);       // Serielle Verbindung konfigurieren, Baud Rate ist 9600 (muss auch am Monitor eingestellt sein)
}

void loop() {
  digitalWrite(ledPin, HIGH);      // LED anschalten
  wert1 = analogRead(PotiPin1);    // Auslesen des Wertes des ersten Potis
  wert2 = analogRead(PotiPin2);    // Auslesen des Wertes des ersten Potis
  
  Serial.print("Poti1 = ");        // "Poti1 = " schreiben
  Serial.print(wert2);             // den Wert der Variable "wert1" schreiben
  Serial.print("\t Poti2 = ");     // "\t" entspricht einem "Tab"
  Serial.print(wert1);             // den Wert der Variable "wert2" schreiben
 
  Taster1 = digitalRead(TastPin1); // Auslesen der Taster 1 bis 4
  Taster2 = digitalRead(TastPin2);
  Taster3 = digitalRead(TastPin3);
  Taster4 = digitalRead(TastPin4);
  
  // Fallunterscheidung: wenn der Taster an ist, "ON" schreiben, sonst "OFF" ("\t" entspricht "Tab").
  // Durch die Pullupwidersta:nde sind die Zusta:nde vertauscht:
  // LOW ist An und HIGH ist Aus.
  if (Taster1 == LOW) {
     Serial.print("\t Taster1 = ON");}
  else {
    Serial.print("\t Taster1 = OFF");}
  
  if (Taster2 == LOW) {
     Serial.print("\t Taster2 = ON");}
  else {
    Serial.print("\t Taster2 = OFF");}
  
  if (Taster3 == LOW) {
     Serial.print("\t Taster3 = ON");}
  else {
     Serial.print("\t Taster3 = OFF");}
  
  if (Taster4 == LOW) {
     Serial.println("\t Taster4 = ON");}
  else {
    Serial.println("\t Taster4 = OFF");}
    
  digitalWrite(ledPin, LOW);       // LED Ausschlaten
  delay(100);                       // Warten
}
