/****************************************************************
   Simple PWM Out
   W Spahn 2017 - dernulleffekt.de

 ****************************************************************/

int CV_Values[8] = {220, 200, 240, 200, 150, 180, 255, 100};      // Voltage output
int CVPin = 6;
unsigned long Uhrzeit = 0;
unsigned long ZeitPunkt = 0;
int Tabellen_Platz = 0;
int State = HIGH;

void setup() {
  // sets the speed on pin 6 (just for a Atmega328 chip):
  TCCR0B = TCCR0B & 0b11111000 | 0x01;
  pinMode(CVPin, OUTPUT);
  analogWrite(CVPin, 200);
  Serial.begin(9600);
}

void loop() {
  for (int i = 0; i < 8; i++) {
    analogWrite(CVPin, CV_Values[i]);
    State = HIGH;
    while (State == HIGH) {
      Uhrzeit = millis();
      if (Uhrzeit - ZeitPunkt >= 100000) {
        ZeitPunkt = Uhrzeit;
        State = LOW;
      }
      Serial.println(i);
    }
    }
  }
