/*====================================================
 * Temperatursensor auslesen und entsprechend Blinken
 *====================================================
 *
 *
 * +5V----------Thermistor-----+------1,5k--------GND
 *                             |  
 *  A0-------------------------+
 *
 *
 * http://dernulleffekt.de    05_2012
 */

int SensorPin = 0;         // Auswahl des Pins fu:r dem Sensor
int LedPin = 13;           // Pin fu:r  LED

int Wert;                  // Variable um die Messergebnisse zu speichern
int Frequenz;              // Variable um die Blinkfrequenz zu speichern

int Zustand = HIGH;        // Variable zum Speichern des Led Zustandes       
long ZeitPunkt = 0;        // Variable zum Speichern des letzten Zeitpunktes an dem die Led geschaltet wurde 
unsigned long Uhrzeit = 0; // Variable um die aktuelle Zeit zu speichern


void setup() {
  pinMode(LedPin, OUTPUT);  // LED Pin als Ausgang setzen
  Serial.begin(9600);       // Serielle Verbindung konfigurieren
}

void loop() {
  Wert = analogRead(SensorPin);         // Auslesen des Wertes am Sensor
  Serial.println(Wert);                 // Daten Senden
  Frequenz = 10 * (600 - Wert);         // Berechnen der Blinkfrequenz
                                        // - Wert 530 entspricht Ko:rpertemperatur
                                        // - Wert 590 entspricht Ko:rpertemperatur
  Blinken(); 
}

void Blinken(){
  Uhrzeit = millis();                   // Aktuelle Zeit speichern
  if(Uhrzeit - ZeitPunkt > Frequenz) {  // Abfragen ob genug Zeit vergangen ist, dann ...
    if (Zustand == HIGH){               // Zustand u:berpru:fen und ...
      Zustand = LOW;                    // ... Zustand a:ndern
    }
    else if (Zustand == LOW){
      Zustand = HIGH;
    }
    digitalWrite(LedPin, Zustand);      // Abha:ngig von der Variablen die Led schalten                 // ... Umschalten,
    ZeitPunkt = Uhrzeit;                // Zeitpunkt des Schaltens speichern
  }
}







