/************************************************
 * IO Port Expander Board - MCP23S17
 * Test
 ***********************************************
 * Wolfgang Spahn 15dez2014
 * 
 * Arduino Anschlu:sse:
 * CS/SS = Pin10
 * MOSI  = Pin11
 * MISO  = Pin12
 * SCK   = Pin13
 * 
 * I/O Expander Anschlu:sse:
 * Bargraph = Pin 0 - 10
 * Button   = Pin 16
 * 
 ************************************************/

#include <SPI.h>              // SPI Library
#include <MCP23S17.h>         // MCP23S17 Classe

MCP IOExpander(0);            // Erstellen der Instanz "IOExpander" mit der Adresse 0
int Taster = 0;

void setup() {
  IOExpander.pinMode(16, HIGH);      // Pin 16 als Input setzen (Logic Level 1 od. HIGH)
  IOExpander.pullupMode(16, HIGH);   // Pull-Up Widerstand setzen
  IOExpander.inputInvert(16, HIGH);  // Eingang Invertieren

  for (int i = 1; i <= 11; i++) {
    IOExpander.pinMode(i, LOW);      // Pin als Ausgang setzen (Logic Level 0 od. LOW)
  }
}

void loop() {
  Taster = IOExpander.digitalRead(16); // Taster auslesen
  if (Taster == HIGH){                 // wenn Taster gedru:ckt, dann ...
    for (int i = 1; i <= 11; i++) {
      IOExpander.digitalWrite(i,HIGH); // ... jede LED anschalten,
      delay(300);                      // mit einer Pause
    }
  }
  else {                               // sonnst, ...
   for (int i = 1; i <= 11; i++) {
      IOExpander.digitalWrite(i,LOW);  // ... alle LEDs ausschalten
    }
  } 
}

