
/**************************************
 * Compas Module 
 *
 * Pollin HDMM01
 * MMC2120MG
 * 
 * I2C
 * 3.3V/5V
 **************************************/



#define  I2ADDR       0x30      // MMC2120=0x30   MMC2121=0x32   MMC2122=0x34 und MMC2123=0x36
#define  TakeMeasure  0x01
#include <Wire.h>

void setup(){
  Wire.begin();
  Serial.begin(115200);
}

void loop(){
  byte MsbX,LsbX,MsbY,LsbY;
  int x,y;
  char line[80];
  Wire.beginTransmission(I2ADDR); // Pollin HDMM01 mit MEMSIC MMC212xMG
  Wire.write(0x00);                // Adressfeld spielt hier keine Rolle
  Wire.write(TakeMeasure);         // Befehl zum Messen
  Wire.endTransmission();         // stop transmitting
  
  delay(20);                      // mindestens 5 Millisekunden warten
  Wire.beginTransmission(I2ADDR); // Pollin HDMM01 mit MEMSIC MMC212xMG
  Wire.write(0x01);                // Adressfeld 1 um die 4 relevanten Register auszulesen
  Wire.requestFrom(I2ADDR, 4);
  while(Wire.available()<4);
  MsbX  =Wire.read();          // obere  4 Bit X
  LsbX  =Wire.read();          // untere 8 Bit X
  MsbY  =Wire.read();          // obere  4 Bit Y
  LsbY  =Wire.read();          // untere 8 Bit Y
  Wire.endTransmission();         // stop transmitting

  x=((MsbX&0x0f)*256)+(LsbX);
  y=((MsbY&0x0f)*256)+(LsbY);
  sprintf(line,"%02X %02X %02X %02X X=%4d Y=%4d\n",MsbX,LsbX,MsbY,LsbY,x,y);
  Serial.print(line);

  delay(400);
}

