/**************************************************
 * Real Time Clock
 *
 ************************************************/
  
#include <Wire.h>
#define DS1307_ADDRESS 0x68

void setup(){
  Wire.begin();
  Serial.begin(9600);
}

void loop(){
  NurAuslesen();
  //DatumUndZeit();
  delay(1000);
}

void NurAuslesen(){
  Wire.beginTransmission(DS1307_ADDRESS);
  Wire.write(0x00);
  Wire.endTransmission();
  
  Wire.requestFrom(DS1307_ADDRESS, 7);
  int eins = Wire.read();
  int zwei = Wire.read();
  int drei = Wire.read();
  int vier = Wire.read();
  int fuenf = Wire.read();
  int sechs = Wire.read();
  int sieben = Wire.read();

  //print the date EG   3/1/11 23:59:59
  Serial.print(eins);
  Serial.print("-");
  Serial.print(zwei);
  Serial.print("-");
  Serial.print(drei);
  Serial.print("-");
  Serial.print(vier);
  Serial.print("-");
  Serial.print(fuenf);
  Serial.print("-");
  Serial.print(sechs);
  Serial.print("-");
  Serial.println(sieben);
}


/************************************************************/

byte bcdToDec(byte val)  {
// Convert binary coded decimal to normal decimal numbers
  return ( (val/16*10) + (val%16) );
}

void DatumUndZeit(){
  // Reset the register pointer
  Wire.beginTransmission(DS1307_ADDRESS);
  byte zero = 0x00;
  Wire.write(zero);
  Wire.endTransmission();

  Wire.requestFrom(DS1307_ADDRESS, 7);

  int second = bcdToDec(Wire.read());
  int minute = bcdToDec(Wire.read());
  int hour = bcdToDec(Wire.read() & 0b111111); //24 hour time
  int weekDay = bcdToDec(Wire.read()); //0-6 -> sunday - Saturday
  int monthDay = bcdToDec(Wire.read());
  int month = bcdToDec(Wire.read());
  int year = bcdToDec(Wire.read());

  //Datum und Zeit drucken   3/1/11 23:59:59
  Serial.print(monthDay);
  Serial.print(".");
  Serial.print(month);
  Serial.print(".20");
  Serial.print(year);
  Serial.print(" ");
  Serial.print(hour);
  Serial.print(":");
  Serial.print(minute);
  Serial.print(":");
  Serial.println(second);
}  

