/*==============================================
 * Kurvezeichnen
 *==============================================
 *
 * Das Programm liest ASCII Zeichen vom seriellen
 * Eingang und zeichnet diese. Die Werte sollen
 * zwischen 0 und 1013 liegen und mit einer neuen
 * Zeile enden.
 *
 * http://dernulleffekt.de
 */

import processing.serial.*; // die Serial Library einlesen

Serial myPort;             // Serielle Port festlegen
int xPos = 1;              // horizontal Position der Kurve

void setup () {
  size(800, 300);            // Fenstergro:sse      
  // Ausdrucken alle zur verfu.gungstehenden Seriellen Ports:
  println(Serial.list());
  // Den Seriellen Port des Arduinos 
  // in die nächste Funktion eintragen, 1,2 oder 3.
  // Seriellen Port o:ffnen, Baudrate festlegen:
  myPort = new Serial(this, Serial.list()[0], 9600);
  // erst bei einem Zeilenumbruch, wird ein "serialEvent" gestartet:
  myPort.bufferUntil('\n');
  background(0);            // Hintergrundfarbe
}


void draw () {
  // alles passiert im "serialEvent"
}

void serialEvent (Serial myPort) {
  // den ASCII Wert abrufen:
  String inString = myPort.readStringUntil('\n');

  if (inString != null) {
    inString = trim(inString); // alle Leerzeichen entferne
    float inByte = float(inString); // in eine Zahl konvertieren
    inByte = map(inByte, 0, 1023, 0, height); // Abbilden auf die Bildschirmgro:sse

    // Linie zeichnen:
    stroke(255, 250, 0); 
    line(xPos, height, xPos, height - inByte);

    // am Ende des Bildschirmes zum Anfang gehen:
    if (xPos >= width) {
      xPos = 0;
      background(0);
    }
    else {
      // sonnst weitergehen:
      xPos++;
    }
  }
}

