/*===========================
 *  Piezo-Blow-Sensor
 *===========================
 * Okt 2011
 *
 * http://dernulleffekt.de
 */


int KaliLed = 13;      // Signal Led fu:r die Kalibrierung
int Piezo = A0;         // Piezo-Sensor an Pin 0

int WindMax = 0;
int WindMin = 1023;
int Wind = 500;

// Anfang
void setup() {
  pinMode(KaliLed, OUTPUT); // Pin als Ausgang deklarieren
  Serial.begin(57600);       // Initialisieren des Seriellen Ports
  
  Kalibrierung();            // Funktion zur Kalibrierung des Sensors
}

//Schleife
void loop() {
  Wind = analogRead(Piezo);                    // Auslesen des Piezos und speichern unter "Wind"

  if ((Wind > WindMax) || (Wind < WindMin) ) { // Wenn der Wind gro:sser der Max oder kleiner dem Min ist, dann ...
    Serial.println(Wind);                      // Drucken des Werte    
  }
  delay(3);                                    // Pause fu:r eine bessere Auswertung
}


// Kalibrierung des Sensors
void Kalibrierung(){
  // Anfang der Kalibrierung
  digitalWrite(KaliLed, HIGH);         // Kalibrierungs Led an
  while (millis() < 5000) {            // 5 Sekunden lang kalibrieren
    Wind = analogRead(Piezo);          // Auslesen des Piezos und speichern unter "Wind"
    if (Wind > WindMax) {              // Wenn Wind gro:sser dem Maximum ist, dann ...
      WindMax = Wind;                  // ... neues Maximum speichern
    }
    if (Wind < WindMin) {              // Wenn Wind kleiner dem Minimum ist, dann ...
      WindMin = Wind;                  // ... neues Minimum speichern
    }
  }
  WindMax = WindMax + 2;               // zur Sicherheit das Maximum erho.hen
  WindMin = WindMin - 2;               // zur Sicherheit das Minimum erho.hen

  // Ende der Kalibrierung
  digitalWrite(KaliLed, LOW);         // Kalibrierungs Led aus
  
  // Ergebnisse Drucken
  Serial.print("Das Maximum = ");
  Serial.println(WindMax);
  Serial.print("und das Minimum = ");
  Serial.println(WindMin);
  }
