/*==========================================
  Einfachtes "Theremin" mit einem Piezo
  ==========================================
  
    PWM9-----------Piezo-------------GND
    
    A0-------------Draht
    
  ==========================================
  http://dernulleffekt.de
*/

int Piezo = 9;             // Pin fu:r den Piezo
int Draht = A2;            // Pin fu:r den Draht
long TonHoehe = 100;       // Variable zum Speichern des ausgelesenen Wertes
long SinusTon = 100;       // Variable zum Speichern des sinus Wertes
long Winkel = 1;

void setup(){
  pinMode(Piezo,OUTPUT);  // Festlegen des Piezo-Pins als Ausgang
}

void loop(){
  TonHoehe = 3 * (analogRead(Draht)+ 10);  // Auslesen des Analogen Einganges (0 bis 1023) und der Variablen zuweisen, ....
                                           // ... umrechnen in Werte zwischen 100 und 3099
  SinusKurve();                            // Funktion zur Berechnung einer Sinuskurve
                                         
  digitalWrite(Piezo,HIGH);                // Piezo anschalten
  delayMicroseconds(TonHoehe);             // Pause zwischen 100 und 3099

  digitalWrite(Piezo, LOW);                // Piezo ausschalten
  delayMicroseconds(SinusTon);             // Pause zwischen 0 und 100
}

// Funktion um eine Sinuskurve zu Berechnen
void SinusKurve(){
  Winkel++;                // Erhoehen des Winkels um 1
  if (Winkel > 179){       // nach einer halben "Umdrehung" ...
    Winkel = 1;            // ...  den Winkel wieder zuru:cksetzen (Winkel von 1 bis 180 Grad)
  }
  SinusTon = 100 * sin(Winkel*PI/180); // Sinuswert des Winkel (im Bogenmass) mit 100 multiplizieren
}
