#!/usr/bin/env python
# -*- coding: utf-8 -*-

#############################################
#Controling a Servo
#############################################

# import required modules
import RPi.GPIO as GPIO
import time

# GPIO pin for the servo 
servoPIN = 17
# to use Raspberry Pi board pin numbers
GPIO.setmode(GPIO.BCM)
# set up GPIO output channel
GPIO.setup(servoPIN, GPIO.OUT)

# create a PWM instance
servo = GPIO.PWM(servoPIN, 50) # GPIO 18 als PWM mit 50Hz
# start PWM
servo.start(2.5)
try:
  while True:
  	 # 2.5 = 180 to 12.5 = 0
    servo.ChangeDutyCycle(5) # change the duty cycle
    time.sleep(0.5)          # half a second delay
    servo.ChangeDutyCycle(7.5)
    time.sleep(0.5)
    servo.ChangeDutyCycle(10)
    time.sleep(0.5)
    servo.ChangeDutyCycle(12.5)
    time.sleep(0.5)
    servo.ChangeDutyCycle(10)
    time.sleep(0.5)
    servo.ChangeDutyCycle(7.5)
    time.sleep(0.5)
    servo.ChangeDutyCycle(5)
    time.sleep(0.5)
    servo.ChangeDutyCycle(2.5)
    time.sleep(0.5)
except KeyboardInterrupt:
  # stop PWM
  servo.stop()
  # clean up
  GPIO.cleanup()
